/*------------------------------------------------------------------------------*
 * File Name: XFWizDlg.h														*
 * Creation: Sim 03-20-2007														*
 * Purpose: Origin C Header Files												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Sim 12-09-2008 QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
 *	Folger 12/11/08 QA80-12764 v8.0985 MODIFY_PEAKS_IN_PA_DURING_CHANGE_PARAMETER_MAKE_ORIGIN_LOCK
 *	Hong 12/17/08 QA80-12798 THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES
 *	Hong 12/22/08 QA80-12798 PA_DO_NOT_SUPPORT_THEME_COMPARE_MENU_DUE_TO_COMPLEXITY
 *	Sim 12-29-2008 QA80-12798 XF_WIZ_THEME_COMPARE								*
 *	Hong 09/24/09 QA80-14350 NLFIT_DLG_NEED_HINT_TO_GUIDE_USER_MAKE_IT_MODALLESS*
 *	Sim 01-07-2009 QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION				*
 *------------------------------------------------------------------------------*/

#ifndef __XF_WIZ_DLG_H__
#define __XF_WIZ_DLG_H__

#include <..\OriginLab\XFWiz.h>

//#include <..\OriginLab\XFWizControl.h>
//#include <..\OriginLab\XFWizDlgNavigation.h>
#include <Control.h>

#define WM_USER_WIZ_DLG_OFFSET (WM_USER + 1201)
enum
{
	//WM_USER_WIZ_DLG_GET_STEPS_CTRL = WM_USER_WIZ_DLG_OFFSET,
	WM_USER_WIZ_DLG_AFTER_LOAD_XF = WM_USER_WIZ_DLG_OFFSET,
	//WM_USER_WIZ_DLG_APPLY_XF,
	WM_USER_WIZ_DLG_UNDO_XF,
	//WM_USER_WIZ_DLG_FINISH,
	WM_USER_WIZ_DLG_PAGE_EVENT_LINK,
	WM_USER_WIZ_DLG_CLOSE,
};
class XFWizRunModelDlg : public XFWizRunModelBase
{
public:
	XFWizRunModelDlg(HWND hDlg, WizardControl *pWizCtrl);
	
public:
	//virtual bool	UpdateSteps(const StringArray &saXFNames);
	//void SetMapStepLabels(const StringArray& saMapXFNames, const StringArray& saMapXFLabels);
	virtual bool	UpdateSteps(const StringArray &saSteps);
	
	virtual bool	ActiveStep(int nStep);
	void SetWizCtrlEventHandler(ClassObject m_objEventHandler);
	
	virtual void	SetPageEventLink(bool bTurnOn);
	virtual bool	OnAfterLoadXF();
	virtual bool	OnUndoXF();
	
	virtual void	Close(int nModalRet = -1);
protected:
	DWORD		SendDlgMsg(DWORD msg, DWORD wParam = 0, DWORD lParam = 0);
	DWORD		PostDlgMsg(DWORD msg, DWORD wParam = 0, DWORD lParam = 0);
	
	//bool		GetStepLabels(const StringArray& saXFNames, StringArray& saXFLables);
	
protected:
	HWND m_hDlg;
	WizardControl *m_pXFWizCtrl;
	ClassObject m_objWizCtrlEventHandler;
	
	StringArray m_saMapXFNames;
	StringArray m_saMapXFLabels;
};
class XFWizRunModelChangeParam : public XFWizRunModelDlg
{
public:
	XFWizRunModelChangeParam(HWND hDlg, WizardControl *pWizCtrl);
};

#include <..\OriginLab\DialogEx.h>
#define BASE_WINDOW		MultiPaneDlg
#include <..\OriginLab\XFDynaDlg_.h>

//#include <..\OriginLab\XFWizNavigation.h>
#include <..\OriginLab\XFWizManager.h>

class XFWizDlg : public XFDynaDlg
{
public:
	//XFWizDlg(XFCore *pXFCore);
	XFWizDlg(XFWizManager *pXFWizManager);
	~XFWizDlg();
	
	/// Iris 11/06/2008 v8.0966b IMPROVE_GET_SOURCE_GRAPH_CODES
	//BOOL Create(HWND hParent, const TreeNode& trThemes = NULL, const TreeNode& trInputsOutputs = NULL, DWORD dwUIDOp = 0);
	//virtual BOOL Create(HWND hParent, const TreeNode& trThemes = NULL, const TreeNode& trInputsOutputs = NULL, DWORD dwUIDOp = 0);
	///end IMPROVE_GET_SOURCE_GRAPH_CODES
	///---Sim 12-09-2008 QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
	int  	DoModal(HWND hParent);
	///---Sim 12-09-2008 QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
	BOOL		Create(HWND hParent);
	
protected:
	EVENTS_BEGIN_DERIV(XFDynaDlg)
		ON_SYSCOMMAND(OnSystemCommand)
		ON_GETMINMAXINFO(OnMinMaxInfo)
		
		ON_INIT(OnInitDialog)
		ON_READY(OnReady)
		ON_DESTROY(OnDestroy)
		ON_SIZE(OnDlgResize)
		ON_RESTORESIZE(OnRestoreSize)
		
		ON_BN_CLICKED(IDC_SHOW_BOTTOM, OnShowBottomPane)
		ON_BN_CLICKED(IDC_SHOW_TOP, OnShowTopPane)

		ON_BN_CLICKED(IDC_BTN_PREVIOUS, OnPrevious)
		ON_BN_CLICKED(IDC_BTN_NEXT, OnNext)
		ON_BN_CLICKED(IDC_BTN_FINISH, OnFinish);
		ON_BN_CLICKED(IDCANCEL, OnCancel);
		
		//ON_USER_MSG(WM_USER_WIZ_DLG_GET_STEPS_CTRL, OnGetWizCtrl)
		
		ON_USER_MSG(WM_USER_WIZ_DLG_AFTER_LOAD_XF, OnAfterLoadXF)
		
		//ON_USER_MSG(WM_USER_WIZ_DLG_APPLY_XF, OnApplyXF)
		ON_USER_MSG(WM_USER_WIZ_DLG_UNDO_XF, OnUndoXF)
		
		//ON_USER_MSG(WM_USER_WIZ_DLG_FINISH, OnFinishXF)
	
		ON_USER_MSG(WM_USER_WIZ_DLG_PAGE_EVENT_LINK, OnSetPageEventLink)
		
		ON_USER_MSG(WM_USER_WIZ_DLG_CLOSE, OnClose)
		
		//------ Folger 12/11/08 QA80-12764 v8.0985 MODIFY_PEAKS_IN_PA_DURING_CHANGE_PARAMETER_MAKE_ORIGIN_LOCK
		ON_USER_MSG(WM_USER_IS_DIALOG_ROLLEDUP, OnIsDialogRolledup)
		//------
		
		/// Hong 09/24/09 QA80-14350 NLFIT_DLG_NEED_HINT_TO_GUIDE_USER_MAKE_IT_MODALLESS
		ON_USER_MSG(WM_USER_MODAL_CLICK_OUTSIDE, OnClickOutside)
		/// end NLFIT_DLG_NEED_HINT_TO_GUIDE_USER_MAKE_IT_MODALLESS
		
		///Jasmine 04/14/10 QA81-15304 ANNOUNCE_FITTING_FUNC_CHANGE
		ON_ORIGIN_MSG(SN_ON_FITTING_FUNCTION_CHANGE, OnFittingFuncChange)
		///End ANNOUNCE_FITTING_FUNC_CHANGE
	EVENTS_END_DERIV

	//DWORD	OnGetWizCtrl(uint wParam, uint lParam);
	
	virtual BOOL OnInitDialog();
	virtual BOOL OnReady();
	virtual BOOL OnDestroy();
	virtual BOOL OnDlgResize(int nType, int cx, int cy);
	virtual BOOL OnRestoreSize(DWORD dwSizeInfo);
	
	BOOL OnShowBottomPane(Control ctrl);
	
	BOOL OnShowTopPane(Control ctrl);
	
	BOOL OnPrevious(Control ctrl);
	BOOL OnNext(Control ctrl);
	BOOL OnFinish(Control ctrl);
	BOOL OnCancel(Control ctrl);

	BOOL OnAfterLoadXF(uint wParam, uint lParam);
	
	//BOOL OnApplyXF(uint wParam, uint lParam);
	BOOL OnUndoXF(uint wParam, uint lParam);
	
	//BOOL OnFinishXF(uint wParam, uint lParam);
	
	BOOL OnSetPageEventLink(uint wParam, uint lParam);
	
	BOOL OnClose(uint wParam, uint lParam);
	
	/// Hong 09/24/09 QA80-14350 NLFIT_DLG_NEED_HINT_TO_GUIDE_USER_MAKE_IT_MODALLESS
	BOOL OnClickOutside(DWORD wParam, DWORD lParam);
	/// end NLFIT_DLG_NEED_HINT_TO_GUIDE_USER_MAKE_IT_MODALLESS
	
	///Jasmine 04/14/10 QA81-15304 ANNOUNCE_FITTING_FUNC_CHANGE
	BOOL OnFittingFuncChange(uint wParam, uint lParam);
	///End ANNOUNCE_FITTING_FUNC_CHANGE
protected:
	virtual void InvokeHandlerOnDestroy();
	
	virtual	bool IsThemeLoadEnable();
	
	virtual BOOL SaveTheme(TreeNode& trGetN, LPCSTR lpcszThemeName);
	virtual BOOL LoadTheme(TreeNode& trGetN, LPCSTR lpcszThemeName);
	
	/// Hong 12/17/08 QA80-12798 THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES
	//virtual
	///---Sim 12-29-2008 QA80-12798 XF_WIZ_THEME_COMPARE
	//BOOL 	CompareTheme(const TreeNode& trGetN, LPCSTR lpcszThemeName, TreeNode& trDiff) { return FALSE; }// Hong, to do, need sim to implement it}
	BOOL 	CompareTheme(const TreeNode& trGetN, LPCSTR lpcszThemeName, TreeNode& trDiff);
	///---END QA80-12798 XF_WIZ_THEME_COMPARE
	/// end THEME_COMPARING_WITH_GUI_SETTING_NEED_FOR_QUICK_CATCH_OF_CHANGES

	virtual void OnEnableButtons(DWORD dwEnable, int nEventID);
	
	virtual void ResizeDlgControls();
	virtual void resizeDlgToFit(int cx = 0, int cy = 0);

	///---Sim 10-13-2008 NEW_PA_81_THEME_FILTER_SETTING
	virtual BOOL	IsShowThemeSetting();
	virtual void	ShowThemeSetting();
	virtual bool	GetThemeFilterTree(TreeNode& trThemeFilter, TreeNode& trGetN);
	virtual bool	SetThemeFilterTree(TreeNode& trThemeFilter, TreeNode& trGetN);
	///---END NEW_PA_81_THEME_FILTER_SETTING
	
	/// Hong 12/22/08 QA80-12798 PA_DO_NOT_SUPPORT_THEME_COMPARE_MENU_DUE_TO_COMPLEXITY
	//virtual 
	///---Sim 12-29-2008 QA80-12798 XF_WIZ_THEME_COMPARE
	//bool	IsSupportThemeCompare() { return false; }
	bool	IsSupportThemeCompare() { return true; }
	///---END QA80-12798 XF_WIZ_THEME_COMPARE
	/// end PA_DO_NOT_SUPPORT_THEME_COMPARE_MENU_DUE_TO_COMPLEXITY
	
protected:
	//virtual bool						CreatePreview(Page& pg);
	
	//void Constructor();
	//virtual XFCore*						CreateXFCore();
	//virtual XFWizTheme*					CreateXFWizTheme();
	//virtual XFWizInputOutputRange*		CreateXFWizInputOutputRange();
	
	//int		UpdateOperation(DWORD dwUIDOp);
	//PFNDoWizOp							GetDoWizOp();
	
	virtual TreeNode GetTree(bool bEditTree = true, bool bSkipFirstNode = true);
	virtual string GetXFName(string& strXFDescription = NULL);
	string	GetThemeGroupName();
	bool	IsThemeDialog();
	bool	IsChangeParam();
	
	///---Sim 12-09-2008 QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
	void	PrepareTargetPage(Page &pgTarget);
	///---END QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
	
	BOOL		OnWizardStepActivate(int nIndexActivate, int nIndexDeactivate);
	//bool		SetActiveStep(int nStep);
private:
	bool updateBottomPaneSize();
	bool updateTopPaneSize();
	void updatePaneSize();
	
	void updateNavigationButton();
	void disableGoNextButton();
	
protected:
	///---Sim 12-09-2008 QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
	bool					m_bDeleteOnDestroy;
	///---END QA80-12741 OPERATION_UNPROTECT_IO_RANGE_IN_EXEC_TIME_OF_CHANGE_PARAM_FUNC
	
	//XFWizTheme				*m_pXFWizTheme;
	//XFWizInputOutputRange	*m_pXFWizIO;
	//XFWizControl			*m_pXFWizCtrl;
	//WizardControl			*m_pXFWizCtrl;
	//XFWizDlgNavigation		*m_pXFWizDlgNavg;
	
	
	XFWizManager			*m_pXFWizManager;
	XFWizRunModelDlg		*m_pXFWizRM;
	
	//XFWizNavigation			*m_pXFWizNavg;
	WizardControl			m_XFWizCtrl;
	
	ComboBox				m_comboTheme;
	Control					m_btnPrevious;
	Control					m_btnNext;
	Control					m_btnFinish;
	
	//DWORD					m_dwUIDOp;
	
	RECT					m_rectXFDyna;
};

///---Sim 01-07-2009 QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION
class XFWizRunModelShowGUI : public XFWizRunModelBase
{
public:
	XFWizRunModelShowGUI();
};

class XFWizShowGUI
{
public:
	XFWizShowGUI(XFWizManager &xfwizManager);
	~XFWizShowGUI();
public:
	bool		Show();
	
protected:
	XFWizManager			*m_pXFWizManager;
	
	XFWizRunModelShowGUI	m_XFWizRM;
};
///---END QA81-14898 SHOW_GUI_SETTINGS_FOR_XFWIZ_OPERATION

#endif		//__XF_WIZ_DLG_H__
